<?php

require_once ('jpgraph/jpgraph.php');
require_once ('jpgraph/jpgraph_line.php');
require_once ('jpgraph/jpgraph_log.php');
require_once ('jpgraph/jpgraph_mgraph.php');

// $datax = array('Luffy', 'Zorro', 'Nami', 'Pipo', 'Sandy', 'Chopper', 'Robin', 'Franky', 'Brook');
$datax1 = array(48,139,324,862,1394,3085,4386,8757,9776);
$datay1 = array(1,2,3,4,5,6,7,8,9);

$datax2a = array(9776,13000);
$datax2b = array(9776,15000);
$datax2c = array(9776,20000);
$datay2 = array(9,10);


$p1 = new LinePlot($datay1, $datax1);
$p2a = new LinePlot($datay2, $datax2a);
$p2b = new LinePlot($datay2, $datax2b);
$p2c = new LinePlot($datay2, $datax2c);

// Setup the linear graph 
$graphLin = new Graph(350,300);
$graphLin->SetScale("intint", 0, 10, 0, 20000);
$graphLin->SetTickDensity(TICKD_DENSE);
$graphLin->title->Set('Evolution de l\'équipage (linéaire)');
$graphLin->xaxis->title->Set('Pages');
$graphLin->xaxis->scale->ticks->Set(5000,1000);
$graphLin->yaxis->title->Set('Membres');
$graphLin->legend->SetPos(0.07,0.74,'right','bottom');
$graphLin->legend->SetFrameWeight(1);
$graphLin->legend->SetColumns(1);
$graphLin->legend->SetReverse(true);
$graphLin->SetMargin(40, 20, 30, 0);
$graphLin->Add($p2c);
$graphLin->Add($p2b);
$graphLin->Add($p2a);
$graphLin->Add($p1);

// Setup the logarithmic graph 
$graphLog = new Graph(350,300);
$graphLog->SetScale("logint", 0, 10, 1, 5);
$graphLog->SetTickDensity(TICKD_DENSE);
$graphLog->title->Set('Evolution de l\'équipage (logarithmique)');
$graphLog->xaxis->title->Set('Pages');
$graphLog->yaxis->title->Set('Membres');
$graphLog->legend->SetPos(0.07,0.74,'right','bottom');
$graphLog->legend->SetFrameWeight(1);
$graphLog->legend->SetColumns(1);
$graphLog->legend->SetReverse(true);
$graphLog->SetMargin(40, 20, 30, 0);
$graphLog->Add($p2c);
$graphLog->Add($p2b);
$graphLog->Add($p2a);
$graphLog->Add($p1);

$p1->SetLegend("Membres connus");
$p1->SetColor("#528BC8");
$p1->mark->SetType(MARK_SQUARE);
$p1->mark->SetColor("#528BC8");
$p1->mark->SetFillColor("#528BC8");

$p2a->SetLegend("H1 : tome 66, page 13000");
$p2a->SetColor("#98C852");
$p2a->mark->SetType(MARK_SQUARE);
$p2a->mark->SetFillColor("#98C852");
$p2a->mark->SetColor("#98C852");

$p2b->SetLegend("H2 : tome 77, page 15000");
$p2b->SetColor("#C65351");
$p2b->mark->SetType(MARK_SQUARE);
$p2b->mark->SetFillColor("#C65351");
$p2b->mark->SetColor("#C65351");

$p2c->SetLegend("H3 : tome 102, page 20000");
$p2c->SetColor("#BD51C6");
$p2c->mark->SetType(MARK_SQUARE);
$p2c->mark->SetFillColor("#BD51C6");
$p2c->mark->SetColor("#BD51C6");


// $graphLin->Stroke();

$mgraph = new MGraph();
$xpos1=0;$ypos1=0;
$xpos2=350;$ypos2=0;
$mgraph->Add($graphLin,$xpos1,$ypos1);
$mgraph->Add($graphLog,$xpos2,$ypos2);
$mgraph->SetMargin(0, 0, 0, 0);

$mgraph->Stroke();

?>
